﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VIMT.VideoVisit.Messages;
using VIMT.VideoVisit.Services.XSD;
using VIMT.VideoVisit.Services.Rest;
using VRM.Integration.Servicebus.Core;
using System.Collections.Generic;

namespace UnitTestProject1
{
    [TestClass]
    public class UnitTest1
    {
           //<http://vrm-crm/UDOSRO/userdefined/edit.aspx?etc=8&id=%7b2BA81618-D5C2-E411-80CD-00155D5564CC%7d>
        //private static string _crmeOrg = "UDOSRO";
        //private static Guid _crmeUserId = Guid.Parse("0A7314B7-ACBE-E411-80CD-00155D5564CC");

        //<https://DNS        .crmo.dev.crm.vrm.vba.DNS   /VRMUDOConfig/userdefined/edit.aspx?etc=8&id=%7b2BA81618-D5C2-E411-80CD-00155D5564CC%7d>
        //crmeUser - RiCarr - Station number 1 - changed 317
        //private static string _crmeOrg = "VRMUDOConfig";
        //private static string _crmeOrg = "UDOInt";
        private static string _crmeOrg = "UDODEV";
        // private static Guid _crmeUserId = Guid.Parse("2BA81618-D5C2-E411-80CD-00155D5564CC");

        //private static string _crmeOrg = "VRMUDODev";
        private static Guid _crmeUserId = Guid.Parse("2BA81618-D5C2-E411-80CD-00155D5564CC");

        [TestMethod]
        public void testCreate()
        {
            VIMTTmpPatients pat1 = new VIMTTmpPatients
            {

                Id = new VIMTTmpPersonIdentifier { AssigningAuthority = "ICN", UniqueId = "1016433599V285591" },
                Name = new VIMTTmpPersonName { FirstName = "PatientOneFirstName", LastName = "PatientOneLastName" },
                ContactInformation = new VIMTTmpContactInformation { PreferredEmail = "apatientone@microsoft.com", TimeZone = VIMTTmpTimeZone.EST },
                Location = new VIMTTmpLocation { Type = VIMTTmpLocationType.NonVA },
                VirtualMeetingRoom = new VIMTTmpVirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "1234", Url = "http://care.DNS   /vmr" }
            };
            VIMTTmpPatients pat2 = new VIMTTmpPatients
            {

                Id = new VIMTTmpPersonIdentifier { AssigningAuthority = "ICN", UniqueId = "1016433599V285592" },
                Name = new VIMTTmpPersonName { FirstName = "PatientTwoFirstName", LastName = "PatientTwoLastName" },
                ContactInformation = new VIMTTmpContactInformation { PreferredEmail = "apatienttwo@microsoft.com", TimeZone = VIMTTmpTimeZone.CST },
                Location = new VIMTTmpLocation { Type = VIMTTmpLocationType.NonVA },
                VirtualMeetingRoom = new VIMTTmpVirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "3456", Url = "http://care.DNS   /vmr" }
            };

            var pats = new[] { pat1, pat2 };
            VIMTTmpProviders prov1 = new VIMTTmpProviders
            {
                Name = new VIMTTmpPersonName { FirstName = "DoctorOneFirstName", LastName = "DoctorOneLastName" },
                Id = new VIMTTmpPersonIdentifier { AssigningAuthority = "IEN", UniqueId = "10164" },
                ContactInformation = new VIMTTmpContactInformation { PreferredEmail = "PII               ", TimeZone = VIMTTmpTimeZone.EST },
                VirtualMeetingRoom = new VIMTTmpVirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "2345", Url = "http://care.DNS   /vmr" },
                Location = new VIMTTmpLocation
                {
                    Type = VIMTTmpLocationType.VA,
                    Facility = new VIMTTmpFacility { SiteCode = "688", Name = "Washington DC" },
                    Clinic = new VIMTTmpClinic { Ien = "IEN", Name = "Doctor's Office" }
                }
            };
            VIMTTmpProviders prov2 = new VIMTTmpProviders
            {

                Name = new VIMTTmpPersonName { FirstName = "DoctorTwoFirstName", LastName = "DoctorTwoLastName" },
                Id = new VIMTTmpPersonIdentifier { AssigningAuthority = "IEN", UniqueId = "10165" },
                ContactInformation = new VIMTTmpContactInformation { PreferredEmail = "PII               ", TimeZone = VIMTTmpTimeZone.CST },
                VirtualMeetingRoom = new VIMTTmpVirtualMeetingRoom { Conference = "testVAVMR@pexip.com", Pin = "5678", Url = "http://care.DNS   /vmr" },
                Location = new VIMTTmpLocation
                {
                    Type = VIMTTmpLocationType.VA,
                    Facility = new VIMTTmpFacility { SiteCode = "688", Name = "Washington DC" },
                    Clinic = new VIMTTmpClinic { Ien = "IEN", Name = "Doctor's Office" }
                }
            };
            var provs = new[] { prov1, prov2 };

            var request = new VIMTTmpCreateAppointmentRequest
              {
                  OrganizationName = _crmeOrg,
                  UserId = _crmeUserId,
                  Debug = true,
                  LogSoap = true,
                  LogTiming = true,
                  VIMTTmpCreateAppointmentRequestDataInfo = new VIMTTmpCreateAppointmentRequestData
                  {
                      Duration = 30,
                      DateTime = "2001-12-31T12:00:00",
                      SchedulingRequestType = VIMTTmpSchedulingRequestType.OTHER_THAN_NEXT_AVAILABLE_PATIENT_REQUESTED,
                      Type = VIMTTmpAppointmentType.REGULAR,
                      BookingNotes = "BookingNotes",
                      DesiredDate = "2001-12-31T12:00:00",
                      Version = "1.0",
                      Id = "uuid",
                      Patients = pats,
                      Providers = provs

                  },
                 

              };

            var response = request.SendReceive<VIMTTmpCreateAppointmentResponse>(MessageProcessType.Local);
        }

        [TestMethod]
        public void testCancel()
        {
            var request = new VIMTTmpCancelAppointmentRequest
            {
                OrganizationName = _crmeOrg,
                UserId = _crmeUserId,
                Debug = true,
                LogSoap = true,
                LogTiming = true,
                VIMTTmpCancelAppointmentRequestDataInfo = new VIMTTmpCancelAppointmentRequestData
                {
                    Id = "uuid",
                    Status = new VIMTTmpStatus { Code = VIMTTmpStatusCode.CANCELLED_BY_PATIENT, Reason = VIMTTmpReasonCode.OTHER }
                },
            };

            var response = request.SendReceive<VIMTTmpCancelAppointmentResponse>(MessageProcessType.Local);
        }
        
    }

}
